/*------------------------------------------------------------------------------*
 * File Name: OrgObj.h															*
 * Creation: CPY 1/7/2002													    *
 * Purpose: OriginObject, this the base class for all Origin internal objects	*
 * Copyright (c) OriginLab Corp.2001, 2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * EJP 2005-04-11 v8.0220 QA70-7588 ATTACH_XFUNC_TO_ORIGINOBJ					*
 *	RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ								*
 * EJP 2005-05-25 v8.0241 QA70-7218 NEW_MATRIX_WORKBOOK, add GetSrcOperation to OriginObject
 *	RVD 6/8/2005 QA70-7777 v8.0248 ATTACH_XF_TREE								*
 *	RVD 10/27/2005 QA70-8233 v8.0325 LEAD_EPRINT								*
 *	RVD 10/30/2006 QA70-9062 v8.0498 NEW_SCALER_GROBJ_THEME						*
 *	ML 8/3/2007 UNNECESSARILY_UNDOABLY_APPLYING_THEME_ON_IMPORT_SPARKLINES_ETC	*
 *	RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR				*
 *	YuI 02/01/08 QA70-11025 OLD_FDF_FILES_FAIL_TO_COMPILE						*
 *	RVD 8/4/2009 qa70-14064 DELETE_WKS_NAMED_STYLE_PROPERTY						*
 *	Hong 01/13/10 QA80-13590-P9 NLFIT_SUPPORT_BOLD_AND_RED_COLOR_FOR_ERR_MSG_IN_MSG_LOG
 *------------------------------------------------------------------------------*/

#ifndef _ORGOBJ_H
#define _ORGOBJ_H

// Comments last updated by Iris on 03/13/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:OriginObject_(class)
*/
class OriginObject
{
public:
	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-OriginObject
	*/
	OriginObject(); // Default constructor for OriginObject.


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-IsValid
	*/
	BOOL		IsValid(); // Checks the validity of this Origin object.


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Destroy
	*/
	BOOL		Destroy(DWORD dwCntrl = OCD_DEL_LINKED_OBJS | OCD_DEL_PARENT_IF_LAST); // Destroy (delete) the OriginObject.

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Detach
	*/
	void		Detach();  //CPY 8/21/08 I moved here from layer class as it should only be in base class

	// Comments last updated by GJL on 04/20/2005
	/**$
	Remarks:
		Show or hide the Origin object.
	Keywords:
		Show;Hide;Visible;
	Example1:
		// Example hides then shows the active page
		int OriginObject_Show_ex1()
		{
		    Page pg = Project.Pages();
			if( pg.IsValid() )
			{
				pg.Show(FALSE); // Hide the active page
				printf("Now you don't see it\n");
				DWORD dw1 = GetTickCount();
				while(GetTickCount() - dw1 < 3000)
					;
				pg.Show(TRUE);
				printf("Now you do\n");
				return 0;
			}
			else
			{
				printf("No child windows in project\n");
				return -1;
			}
		}
	Parameters: 
		bShow=[input]Pass TRUE to show the object and FALSE to hide it
	Return:
		Returns TRUE on successful exit and FALSE on failure.
	SeeAlso:
		
	*/
	BOOL		Show(BOOL bShow = TRUE); // Show or hide the Origin object.


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetParent
	*/
	void		GetParent(OriginObject& obj); // Get the parent object of this Origin object.


#if _OC_VER >= 0x0800
	// Comments last updated by Iris on 02/21/2008
	/**#
			Retrieves selection ranges as strings from active graph or worksheet. If there is nothing selected, the returned arrays will be empty.
		Keywords:

		Example1:
			int OriginObject_GetSelection_Ex1()
			{
				Page pg = Project.Pages(-1);	
				if(!pg)
				{
					printf("Please make sure one window is active with data selection\n");
					return -1;
				}
				
				vector<string> arrstrIndependent;
				vector<string> arrstrDependent;
				int nWinType = pg.GetSelection(arrstrIndependent, &arrstrDependent);
				if(EXIST_WKS == nWinType)
				{
					printf("Range\t\tX\t\tY\n");
					for(int ii = 0; ii < arrstrIndependent.GetSize(); ii++)
					{
						printf("Range%d\t%s\t%s\n", ii+1, arrstrIndependent[ii], ii<arrstrDependent.GetSize() ? arrstrDependent[ii] : "None");
					}
				}
				else if(EXIST_MATRIX == nWinType )
				{
					printf("Range\t\tX\n");
					for(int ii = 0; ii < arrstrIndependent.GetSize(); ii++)
					{
						printf("Range%d\t%s\n", ii+1, arrstrIndependent[ii]);
					}
				}				
				else
					out_int("GetSelection returns ", nWinType);
				
				return 0;
			}
		Parameters:
			arrstrIndependent=[output]an array of strings to receive the independent (X) data ranges. Each one should correspond to one element in 
					arrstrDependent if parrstrDependent is not NULL. Each of those ranges in the array should have only one column (which is to be used as X).
					If parrstrDependent is NULL, then we are not considering independent/dependent matching and the result should be a single string (GetSize() == 1).
					If there are multiple ranges, then they will be separated by commas.
			parrstrDependent=[output]an array of strings to receive the dependent (Y) data ranges. Each one should correspond to one element in arrstrIndependent.
			pstrZ =[output]an array of strings to receive the Z data ranges. Each one should correspond to one element in arrstrIndependent.
			pstrErrorBars = [output] an array of strings to receive the Y-error bar data ranges. Each one should correspond to one element in  arrstrDependent. 
					Each of those ranges in the array should have only one column (which is to be used as Yerror). If for some Y error bar cannot be found, 
					the corresponding string in the vector should be empty.
			parrPlotObjUIDs=[output]optional array to receive the unique IDs of the plot objects in the active layer if the selection is made from a graph.
		Return:
			0 if no valid selection, -1 if there is conflict in the selection, otherwise returns EXIST_WKS, EXIST_EXTERN_WK, EXIST_MATRIX or EXIST_PLOT
		SeeAlso:
			Project::GetDataRange, Project::RemoveDataRange, Project::AddDataRange, DataRange::AddInput
	*/
	int GetSelection(vector<string> &arrstrIndependent, vector<string> *parrstrDependent = NULL, vector<string> *pstrZ = NULL, vector<string> *pstrErrorBars = NULL, vector<uint> *parrPlotObjUIDs = NULL);

	/// RVD 10/27/2005 QA70-8233 v8.0325 LEAD_EPRINT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-ExportAdvanced
	*/
	BOOL	ExportAdvanced(LeadPrintSettings& lps);
	/// end LEAD_EPRINT

	// Comments last updated by CPY on 04/22/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetSelection
	*/
	int	GetSelection(DataRange& dr, int* pnMergeCounts = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-FindIncomingOperations
	*/
	int  FindIncomingOperations(vector<uint> &vUIDs); // Find UIDs where this object is an output


	// Last Updated : 20050428 GRD
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-FindOutgoingOperations
	*/
	int  FindOutgoingOperations(vector<uint> &vUIDs); // Find UIDs where this object is an input

	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetConnectedObjects
	*/
	int	GetConnectedObjects(vector<uint> &vUIDs);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-AddInternalMenu
	*/
	BOOL	AddInternalMenu(HWND hMenu, int nMenuID, int nMenuPos); // Adds an internal menu to the main menu created from resource


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-ProcessCommand
	*/
	BOOL	ProcessCommand(int nCmd, DWORD dwCmdType = PCMD_ORIGIN_INTERNAL, DWORD wParam = 0, DWORD lParam = 0); // Processes internal menu/button commands


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetMenuID
	*/
	int		GetMenuID(int nSeletionType, int xCur, int yCur, int &npos);


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetIncomingOperation
	*/
	OperationBase&	GetIncomingOperation(BOOL bDirect, int& nOuputIndex);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetEventHandler
	*/
	BOOL	SetEventHandler(LPCSTR lpcszClassName);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetEventHandler
	*/
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//string	GetEventHandler(BOOL bCheckValid = false);
	string	GetEventHandler(BOOL bCheckValid = false, BOOL bDeafult = FALSE);
	/// end EVENT_HANDLING_ETC_FOR_OK 


// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Invalidate
	*/
	void		Invalidate(BOOL bUpdate = TRUE); // Invalidate an OriginObject.


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetIndex
	*/
	int		GetIndex(); // Get the index of an object in an Origin C Collection


	// Comments last updated by GRD on 2005.05.09
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetIndex
	*/
	BOOL		SetIndex(int nIndex, BOOL bUndo = TRUE); // Set the index of an object in a collection


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetLongName
	*/
	string		GetLongName(); // Get the long name of an object


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetLongName
	*/
	BOOL		SetLongName(LPCSTR lpcszLongName, BOOL bUpdateShortName = true, BOOL bUpdateDisplay = true); // Sets the long name of an object


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetComments
	*/
	string		GetComments(); // Retrieve the comments from an object that supports Comments


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetComments
	*/
	BOOL		SetComments(LPCSTR lpcszComments); // Sets the comments with a text string to an object that supports Comments


	/// EJP 2005-04-11 v8.0220 QA70-7588 ATTACH_XFUNC_TO_ORIGINOBJ
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-AttachXFunction
	*/
	/// RVD 11/21/2005 QA80-8338 v8.0339 ATTACH_XF_USER_TREE
	//BOOL AttachXFunction(LPCSTR lpcszName, DWORD dwCntrl = OCD_INITDATA);
	BOOL AttachXFunction(LPCSTR lpcszName, TreeNode& treeUserData = NULL, int nIndex = 0, DWORD dwCntrl = OCD_INITDATA);
	/// end ATTACH_XF_USER_TREE
	/// end ATTACH_XFUNC_TO_ORIGINOBJ

	/// RVD 6/8/2005 QA70-7777 v8.0248 ATTACH_XF_TREE
	/**#
	*/
	BOOL AttachXFunction(TreeNode& tree, DWORD dwCntrl = OCD_INITDATA);
	/// end ATTACH_XF_TREE


	/// RVD 4/15/2005 QA70-7597 v8.0223 MARKER_GROBJ
	/**#
	*/
//	BOOL FindMatchingPoint(double* dx, double* dy, double* dz);
	/// end MARKER_GROBJ

	/**#
	*/
	BOOL SendMessage(uint uMsg, DWORD wParam, DWORD lParam);
	/**#
	*/
	BOOL PostMessage(uint uMsg, DWORD wParam = 0, DWORD lParam = 0);
	

	/// EJP	2005-04-20 v8.0225 QA70-7634 OC_SETNAME_RENAME_CLEANUP
	// Comments last updated by GRD on 2005.05.10
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetName
	*/
	BOOL SetName(LPCSTR lpcszNewName, DWORD dwOptions = 0); // Rename a Page.
	/// end OC_SETNAME_RENAME_CLEANUP


#endif	//_OC_VER > 0x0800


#if _OC_VER > 0x0703
// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetStorage
	*/
	storage		GetStorage(LPCSTR lpcszName, bool bAdd = FALSE); // Access storage areas.


	// Comments last updated by GRD on 2005.05.16
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetStorageNames
	*/
	BOOL 		GetStorageNames(vector<string> &vsNamesn, int nType = STORAGE_TYPE_ALL); // Get names of storage class objects


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-CopyFormat
	*/
	/// RVD 10/30/2006 QA70-9062 v8.0498 NEW_SCALER_GROBJ_THEME
	//BOOL		CopyFormat(DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL); // Copy object format into Clipboard
	BOOL		CopyFormat(DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL,
						/// RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR
						//DWORD dwPropertiesFilterEx = FPBEX_ALL, DWORD dwObjFilterEx = FOB2_ALL); // Copy object format into Clipboard
						DWORD dwPropertiesFilterEx = FPBEX_ALL, DWORD dwObjFilterEx = FOB2_ALL,
						vector<int>* piaErrors = NULL, vector<string>* psaErrors = NULL);
						/// end FIX_THEME_LIMIT_REACHED_ERROR
	/// end NEW_SCALER_GROBJ_THEME


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-ApplyFormat
	*/
	/// ML 8/3/2007 UNNECESSARILY_UNDOABLY_APPLYING_THEME_ON_IMPORT_SPARKLINES_ETC
	//BOOL	ApplyFormat(LPCSTR lpcszXMLPath, BOOL bRepaint = TRUE, BOOL bRelative = FALSE); // Apply format stored in theme file to object
	/// RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR
	//BOOL	ApplyFormat(LPCSTR lpcszXMLPath, BOOL bRepaint = TRUE, BOOL bRelative = FALSE, BOOL bUndo = FALSE);
	BOOL	ApplyFormat(LPCSTR lpcszXMLPath, BOOL bRepaint = TRUE, BOOL bRelative = FALSE, BOOL bUndo = FALSE,
		vector<int>* piaErrors = NULL, vector<string>* psaErrors = NULL);
	/// end FIX_THEME_LIMIT_REACHED_ERROR
	/// end UNNECESSARILY_UNDOABLY_APPLYING_THEME_ON_IMPORT_SPARKLINES_ETC


	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-ApplyFormat
	*/
	/// ML 8/3/2007 UNNECESSARILY_UNDOABLY_APPLYING_THEME_ON_IMPORT_SPARKLINES_ETC
	//BOOL	ApplyFormat(const TreeNode& trNode, BOOL bRepaint = TRUE, BOOL bRelative = FALSE); // Apply format stored in tree to object
	/// RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR
	//BOOL	ApplyFormat(const TreeNode& trNode, BOOL bRepaint = TRUE, BOOL bRelative = FALSE, BOOL bUndo = FALSE);
	BOOL	ApplyFormat(const TreeNode& trNode, BOOL bRepaint = TRUE, BOOL bRelative = FALSE, BOOL bUndo = FALSE,
		vector<int>* piaErrors = NULL, vector<string>* psaErrors = NULL);
	/// end FIX_THEME_LIMIT_REACHED_ERROR
	/// end UNNECESSARILY_UNDOABLY_APPLYING_THEME_ON_IMPORT_SPARKLINES_ETC


	/// RVD 8/4/2009 qa70-14064 DELETE_WKS_NAMED_STYLE_PROPERTY
	// Mostly the same as ApplyFormat(const TreeNode& trNode, ...) above, only BOOLs are combined into STYLE_* bits.
	// Another difference is that extra bits could be applied, like STYLE_COMPLETE, which is important for wks theme to restore named styles.
	BOOL	ApplyFormat(DWORD dwCntrl, const TreeNode& trNode, vector<int>* piaErrors = NULL, vector<string>* psaErrors = NULL);
	/// end DELETE_WKS_NAMED_STYLE_PROPERTY
		
	// Comments last updated by GRD on 2005.05.19
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetFormat
	*/
	Tree	GetFormat(DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL, BOOL bGetTagNames = TRUE,
		/// RVD 12/3/2007 QA70-10771 v8.0760 FIX_THEME_LIMIT_REACHED_ERROR
		//BOOL bRelative = FALSE, DWORD dwPropertiesFilter2 = FPBEX_ALL, DWORD dwObjFilter2 = FOB2_ALL);
		BOOL bRelative = FALSE, DWORD dwPropertiesFilter2 = FPBEX_ALL, DWORD dwObjFilter2 = FOB2_ALL,
		vector<int>* piaErrors = NULL, vector<string>* psaErrors = NULL); // Get object format into Tree
		/// end FIX_THEME_LIMIT_REACHED_ERROR


	/// Iris 2/25/2008 v8.0811 MAKE_FIT_CURVE_PLOT_AND_DATA_HAVE_SEPARATE_CONTROL
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-UpdateThemeIDs
	*/
	int		UpdateThemeIDs(TreeNode& trNode, LPCTSTR lpcszName = NULL, LPCTSTR lpcszValue = NULL); // Update IDs in trNode acording to theme rules


	// Comments last updated by GRD on 2005.05.19
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetMemory
	*/
	BOOL GetMemory(LPCSTR lpcszName, vector<byte>& vb); // Get named binary storage into vector of bytes


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SetMemory
	*/
	BOOL	SetMemory(LPCSTR lpcszName, vector<byte>& vb); // Set/Create named binary storage


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Show
	*/
	BOOL	Show; // Read/Write the Show/Hide property of any Origin object


	// Comments last updated by GJL on 04/20/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetName
	*/
	string		GetName();

// Last Update : 2007.11.7 CPY moved here from wksheet.h
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetName
*/
	BOOL	GetName(string &str); // Get the name of a worksheet or matrix layer

	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetUID
	*/
	/// YuI 12/14/04 v7.5174 QA70-7257 GUID_NEEDED_FOR_RANGE_AND_OPERATION
	//	UINT		GetUID(BOOL bCreate = FALSE);
	UINT		GetUID(BOOL bCreate = FALSE, string* pStrGUID = NULL); // Gets internal Unique IDentification number of Origin object
	/// end GUID_NEEDED_FOR_RANGE_AND_OPERATION


// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-ConnectTo
	*/
	/// YuI 11/27/06 QA70-9156 MORE_OPTIONS_TO_CONNECTING_OBJECTS
	//	BOOL	ConnectTo(OriginObject& objTarget, int nTargetReferencePoint = -1, int nReferencePoint = -1, BOOL bVisibleConnector = TRUE, BOOL bRigidConnector = TRUE);
	BOOL	ConnectTo(OriginObject& objTarget, int nTargetReferencePoint = -1, int nReferencePoint = -1, BOOL bVisibleConnector = TRUE, DWORD dwRigid = OCR_SITE1 | OCR_SITE2, RECT* lpConfineRect = NULL);
	/// end MORE_OPTIONS_TO_CONNECTING_OBJECTS
#endif //#if _OC_VER > 0x0703


// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetGrid
	*/
	void	GetGrid(Grid& grid);


	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-AutoSize
	*/
	BOOL	AutoSize(DWORD dwCntrl = 0, DWORD lParam = 0, void* pVoid = NULL, BOOL bUndo = FALSE, void* pOpt = NULL);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-SaveAs
	*/
	BOOL	   SaveAs(LPCSTR lpcszFileName, DWORD dwCtrl = 0); // Saves (Serializes) an OriginObject into an Orgin recognized file type.

	// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Load
	*/
	OriginObject Load(LPCSTR lpcszFile, LPCSTR lpcszOption=NULL);
	
	
	/// TD 12-12-05 QA70-8061 EXTEND_PASSWORD_PROTECTION_TO_PAGE_AND_PROJECT
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Lock
	*/
	BOOL	Lock(LPCSTR lpcszPassword, DWORD dwCtrl);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetLock
	*/
	DWORD GetLock(DWORD dwCtrl = OAM_STRUCTURE);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-Unlock
	*/
	BOOL	Unlock(LPCSTR lpcszPassword, DWORD dwCtrl = 0);
	/// end EXTEND_PASSWORD_PROTECTION_TO_PAGE_AND_PROJECT
	
	
// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetSrcOperation
	*/
	OperationBase& GetSrcOperation(int nRow = -1, int nCol = -1, int *pnTblId = NULL);

	// Comments last updated by Iris 07/22/2008, added #
	/**#
	Remarks:
		
	Keywords:
		
	Example1:
		
	Parameters:
		dwCntrl = [input] 

	Return:
		
	SeeAlso:
	*/
	BOOL	PushUndo(DWORD dwCntrl = 0);

// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetBinaryStorage
	*/
	BOOL	GetBinaryStorage(LPCSTR lpcszName, TreeNode &tn);

// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-PutBinaryStorage
	*/
	BOOL	PutBinaryStorage(LPCSTR lpcszName, const TreeNode &tn);

// Comments last updated by Iris on 2008.02.25
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-GetRangeString
	*/
	BOOL	GetRangeString(string& strRange, DWORD dwCntrl = NTYPE_AUTO);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:OriginObject-CheckShowActivate
	*/
	BOOL	CheckShowActivate();
};


//--------------- pure virtual base classes to be implemented in other headers

///Comments last updated by Cloud 03/15/07
/**$ >
*/
// base class for message log
class OperationLogBase
{
public:
	virtual 	int		WriteSeparator(bool bShowCounter = true, bool bAddNewLine = false )
	{
		/// YuI 02/01/08 QA70-11025 OLD_FDF_FILES_FAIL_TO_COMPILE
		// see my comment in the tracker item for the reason of this code change
		bShowCounter;
		bAddNewLine;
		/// end OLD_FDF_FILES_FAIL_TO_COMPILE
		return 0;
	}
	virtual		void	WriteLine(LPCSTR lpcstr = NULL)
	{
		/// YuI 02/01/08 QA70-11025 OLD_FDF_FILES_FAIL_TO_COMPILE
		// see my comment in the tracker item for the reason of this code change
		lpcstr;
		/// end OLD_FDF_FILES_FAIL_TO_COMPILE
	}

	/// Hong 01/13/10 QA80-13590-P9 NLFIT_SUPPORT_BOLD_AND_RED_COLOR_FOR_ERR_MSG_IN_MSG_LOG
	// Hong, COLORREF can't be seen here, so just use DWORD instead
	//virtual		void	Write(LPCSTR lpcstr)
	virtual		void	Write(LPCSTR lpcstr, BOOL* pbBold = NULL, DWORD* pcrTextClr = NULL)
	/// end NLFIT_SUPPORT_BOLD_AND_RED_COLOR_FOR_ERR_MSG_IN_MSG_LOG
	{
		/// YuI 02/01/08 QA70-11025 OLD_FDF_FILES_FAIL_TO_COMPILE
		// see my comment in the tracker item for the reason of this code change
		lpcstr;
		pbBold;
		pcrTextClr;
		/// end OLD_FDF_FILES_FAIL_TO_COMPILE
	}
	
};
//---------------

#endif // _ORGOBJ_H



